package com.sample.introtoandroid.filestreamofconsciousness;

import java.io.FileOutputStream;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;


public class FileStreamOfConsciousnessActivity extends AppCompatActivity {
    public static final String LOG_FILENAME = "Chat_Log.txt";
    private Handler mHandler = new Handler();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_file_stream_of_consciousness);

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        // Obsługa przycisku Wyślij
        final Button sendButton = (Button) findViewById(R.id.ButtonSend);
        sendButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                logChatMessage();
                final EditText chatText = (EditText) findViewById(R.id.EditTextChat);
                chatText.setText(null);
            }
        });

        // Obsługa przycisku Przejrzyj plik dziennika
        final Button gotoLog = (Button) findViewById(R.id.ButtonSeeLog);
        gotoLog.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                // Przechodzimy do innej aktywności, która wyświetli zawartość pliku.
                Intent intent = new Intent(FileStreamOfConsciousnessActivity.this,
                        ViewLogActivity.class);
                startActivity(intent);
            }
        });
    }

    private void logChatMessage() {
        new Thread(){
            public void run(){
                final EditText chatText = (EditText) findViewById(R.id.EditTextChat);
                String strChat = chatText.getText().toString();

                if (strChat.length() > 0) {
                    strChat = strChat+"\n\n";
                    try {
                        // Otwieramy plik.
                        FileOutputStream fIO = openFileOutput(LOG_FILENAME, MODE_APPEND);
                        // Zapisujemy łańcuch znaków w pliku.
                        fIO.write(strChat.getBytes());
                        // Zamykamy plik.
                        fIO.close();
                        // Informujemy wątek interfejsu użytkownika, że jesteśy gotowi.
                        mHandler.post(new Runnable() {
                            public void run() {
                                Toast.makeText(FileStreamOfConsciousnessActivity.this,
                                        "Zapisano komunikat w dzienniku",
                                        Toast.LENGTH_SHORT).show();
                            }
                        });
                    } catch (Exception e) {
                        // Nie udało się dołączyć tekstu. Obsługujemy błąd.
                    }
                }
            }
        }.start();
    }
}
